/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity.ai;

import com.tristankechlo.livingthings.block.OstrichNestBlock;
import com.tristankechlo.livingthings.init.ModBlocks;
import com.tristankechlo.livingthings.init.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.phys.Vec3;

public class BreakOstrichEggGoal
extends MoveToBlockGoal {
    private final Block block = ModBlocks.OSTRICH_NEST.get();
    private final Mob entity;
    private int breakingTime;
    private boolean destroyNestComplete;
    private int chance;

    public BreakOstrichEggGoal(PathfinderMob creatureIn, double speed, int yMax, int chance, boolean destroyNestComplete) {
        super(creatureIn, speed, 12, yMax);
        this.entity = creatureIn;
        this.destroyNestComplete = destroyNestComplete;
        this.chance = chance;
    }

    public boolean m_8036_() {
        if (!this.entity.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            return false;
        }
        if (this.f_25600_ > 0) {
            --this.f_25600_;
            return false;
        }
        if (this.shouldMoveToDestination()) {
            this.f_25600_ = 20;
            return this.entity.m_217043_().m_188503_(this.chance) == 0;
        }
        this.f_25600_ = this.m_6099_(this.f_25598_);
        return false;
    }

    private boolean shouldMoveToDestination() {
        return this.f_25602_ != null && this.m_6465_((LevelReader)this.f_25598_.m_9236_(), this.f_25602_) ? true : this.m_25626_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.entity.f_19789_ = 1.0f;
    }

    public void m_8056_() {
        super.m_8056_();
        this.breakingTime = 0;
    }

    public void playBreakingSound(LevelAccessor worldIn, BlockPos pos) {
        worldIn.m_5594_(null, pos, ModSounds.OSTRICH_EGG_CRACKS.get(), SoundSource.HOSTILE, 0.5f, 0.9f + this.entity.m_217043_().m_188501_() * 0.2f);
    }

    public void playBrokenSound(Level worldIn, BlockPos pos) {
        worldIn.m_5594_(null, pos, ModSounds.OSTRICH_EGG_CRACKS.get(), SoundSource.BLOCKS, 0.7f, 0.9f + worldIn.f_46441_.m_188501_() * 0.2f);
    }

    public void m_8037_() {
        super.m_8037_();
        Level world = this.entity.m_9236_();
        BlockPos blockpos = this.entity.m_20183_();
        BlockPos blockpos1 = this.findTarget(blockpos, (BlockGetter)world);
        RandomSource random = this.entity.m_217043_();
        if (this.m_25625_() && blockpos1 != null) {
            if (this.breakingTime > 0) {
                Vec3 vector3d = this.entity.m_20184_();
                this.entity.m_20334_(vector3d.f_82479_, 0.3, vector3d.f_82481_);
                if (!world.m_5776_()) {
                    ((ServerLevel)world).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42521_)), (double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.7, (double)blockpos1.m_123343_() + 0.5, 3, ((double)random.m_188501_() - 0.5) * 0.08, ((double)random.m_188501_() - 0.5) * 0.08, ((double)random.m_188501_() - 0.5) * 0.08, (double)0.15f);
                }
            }
            if (this.breakingTime % 2 == 0) {
                Vec3 vector3d1 = this.entity.m_20184_();
                this.entity.m_20334_(vector3d1.f_82479_, -0.3, vector3d1.f_82481_);
                if (this.breakingTime % 6 == 0) {
                    this.playBreakingSound((LevelAccessor)world, this.f_25602_);
                }
            }
            if (this.breakingTime > 60) {
                if (this.destroyNestComplete) {
                    world.m_7471_(blockpos1, false);
                } else {
                    world.m_46597_(blockpos1, (BlockState)world.m_8055_(blockpos1).m_61124_((Property)OstrichNestBlock.EGG, (Comparable)Boolean.valueOf(false)));
                }
                if (!world.m_5776_()) {
                    for (int i = 0; i < 20; ++i) {
                        double d3 = random.m_188583_() * 0.02;
                        double d1 = random.m_188583_() * 0.02;
                        double d2 = random.m_188583_() * 0.02;
                        ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123759_, (double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_(), (double)blockpos1.m_123343_() + 0.5, 1, d3, d1, d2, (double)0.15f);
                    }
                    this.playBrokenSound(world, blockpos1);
                }
            }
            ++this.breakingTime;
        }
    }

    private BlockPos findTarget(BlockPos pos, BlockGetter worldIn) {
        BlockPos[] ablockpos;
        if (worldIn.m_8055_(pos).m_60713_(this.block)) {
            if (((Boolean)worldIn.m_8055_(pos).m_61143_((Property)OstrichNestBlock.EGG)).booleanValue()) {
                return pos;
            }
            return null;
        }
        for (BlockPos blockpos : ablockpos = new BlockPos[]{pos.m_7495_(), pos.m_122024_(), pos.m_122029_(), pos.m_122012_(), pos.m_122019_(), pos.m_7495_().m_7495_()}) {
            if (!worldIn.m_8055_(blockpos).m_60713_(this.block) || !((Boolean)worldIn.m_8055_(blockpos).m_61143_((Property)OstrichNestBlock.EGG)).booleanValue()) continue;
            return blockpos;
        }
        return null;
    }

    protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
        ChunkAccess ichunk = worldIn.m_6522_(pos.m_123341_() >> 4, pos.m_123343_() >> 4, ChunkStatus.f_62326_, false);
        if (ichunk == null) {
            return false;
        }
        if (ichunk.m_8055_(pos).m_60713_(this.block)) {
            return (Boolean)ichunk.m_8055_(pos).m_61143_((Property)OstrichNestBlock.EGG) != false && ichunk.m_8055_(pos.m_7494_()).m_60795_() && ichunk.m_8055_(pos.m_6630_(2)).m_60795_();
        }
        return false;
    }

    public double m_8052_() {
        return 1.25;
    }
}

